/*
 * Decompiled with CFR 0.152.
 */
package com.renttracker.renttrackeriknsa.config;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private DataSource dataSource;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        ((JdbcUserDetailsManagerConfigurer)auth.jdbcAuthentication().dataSource(this.dataSource).usersByUsernameQuery("select email as principal, password as credentails, true from user where email=?").authoritiesByUsernameQuery("select u.email, r.name from user u inner join user_roles ur on(u.id=ur.user) inner join role r on(ur.role=r.id) where u.email=?").passwordEncoder((PasswordEncoder)this.passwordEncoder())).rolePrefix("ROLE_");
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
        return bCryptPasswordEncoder;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/login"})).permitAll().antMatchers(new String[]{"/register"})).permitAll().antMatchers(new String[]{"/home/**"})).hasAnyAuthority(new String[]{"PROPRIETAIRE", "AGENT", "LOCATAIRE"}).anyRequest()).authenticated().and()).csrf().disable()).formLogin().loginPage("/login").failureUrl("/login?error=true")).defaultSuccessUrl("/")).usernameParameter("email").passwordParameter("password").and()).logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/logout")).logoutSuccessUrl("/").and()).exceptionHandling().accessDeniedPage("/access-denied");
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/resources/**", "/static/**", "/css/**", "/js/**", "/images/**"});
    }
}

